# -*- coding: cp1252 -*-
overrideIcon= "r_redshift"

######################################################################
#
# Name:  Redshift Benchmark
# Author:  Royal Render, Holger Schoenberger, Binary Alchemy
# Version: 
# Description: 
#   Redshift offers a benchmark scene that can be downloaded.
#   Many artists have posted their results in this thread: https://www.redshift3d.com/forums/viewthread/12843/
#
#   This script creates a job that executes the benchmark and created an .csv table (e.g. eexcel) with the results.
#
#   
# Copyright (c) Holger Schoenberger - Binary Alchemy
######################################################################
import os
import datetime
import sys

scriptpath= rrGlobal.rrRootPath()+"/render_apps/scripts"
scriptpath= scriptpath.replace("\\","/")
sys.path.append(scriptpath)
import rrScriptHelper

    
#create UI to request redshift file locations
myUI= rrGlobal.getGenericUI()
myUI.addItem(rrGlobal.genUIType.label,"infoLabelA","")
myUI.setText("infoLabelA","This script creates shell scripts for each OS to run the official Redshift Benchmark and adds the result to an .csv table.\nIt tests all GPUs, if multiple exists the 1st and 2nd GPU seperately. And 1st and 2nd together in case you have more than 2 GPUs installed.\nSo you have a good overrview if it is better to use all, 1 or 2 GPUs for a render. (According to Redshift forum information, 1 GPU for 1 frame should be the fastest)")

myUI.addItem(rrGlobal.genUIType.spacerV,"spacerZ","")

myUI.addItem(rrGlobal.genUIType.label,"infoLabel","")
myUI.setText("infoLabel","Please download and extract the benchmark scene zip.\nYou can download it via the URL https://s3.amazonaws.com/s3.redshift3d.com/public/benchmark/RedshiftBenchmarkScenes.zip \nor let it download by the Redshift/bin/RunBenchmark script.")
myUI.addItem(rrGlobal.genUIType.label,"labelconv","")
myUI.setText("labelconv","Note: RR uses its OS conversion table to convert scene and exe locations for the other OS if required.")

myUI.addItem(rrGlobal.genUIType.label,"labelScene","")
myUI.setText("labelScene","Benchmark Scene Vultures.rs:")
myUI.addItem(rrGlobal.genUIType.browseFile,"sceneFile","")
myUI.addItem(rrGlobal.genUIType.spacerV,"spacerF","")

myUI.addItem(rrGlobal.genUIType.label,"labelExeWin","")
myUI.setText("labelExeWin","Location of the executable    Redshift/ bin/ redshiftBenchmark.exe     for Windows:")
myUI.addItem(rrGlobal.genUIType.browseFile,"exeFileWin","")
myUI.addItem(rrGlobal.genUIType.label,"labelExeLx","")
myUI.setText("labelExeLx","Location of the executable    Redshift/ bin/ redshiftBenchmark    for Linux:")
myUI.addItem(rrGlobal.genUIType.browseFile,"exeFileLx","")
myUI.addItem(rrGlobal.genUIType.label,"labelExeOsx","")
myUI.setText("labelExeOsx","Location of the executable    Redshift/ bin/ redshiftBenchmark    for OSX:")
myUI.addItem(rrGlobal.genUIType.browseFile,"exeFileOsx","")

myUI.addItem(rrGlobal.genUIType.spacerV,"spacerZ","")

myUI.addItem(rrGlobal.genUIType.layoutH,"btnLayout","")
myUI.addItem(rrGlobal.genUIType.closeButton,"Create Job","btnLayout")
myUI.addItem(rrGlobal.genUIType.closeButton,"Abort","btnLayout")
myUI.execute()

if myUI.value("Create Job") == 0:
    del myUI
    raise rrCleanExit()

sceneFileLx= myUI.text("sceneFile");
sceneFileWin= myUI.text("sceneFile");
sceneFileOsx= myUI.text("sceneFile");
exeWin= myUI.text("exeFileWin");
exeLx= myUI.text("exeFileLx");
exeOsx= myUI.text("exeFileOsx");

del myUI


ourOS= rrScriptHelper.getOS()
osConvert= rrScriptHelper.rrOSConversion()

osConvert.loadSettings()
sceneFileLx= osConvert.replaceString( sceneFileLx, ourOS, rrScriptHelper.rrOS.Linux,False)
exeLx= osConvert.replaceString( exeLx, ourOS, rrScriptHelper.rrOS.Linux,False)
sceneFileWin= osConvert.replaceString( sceneFileWin, ourOS, rrScriptHelper.rrOS.Windows,False)
exeWin= osConvert.replaceString( exeWin, ourOS, rrScriptHelper.rrOS.Windows,False)
sceneFileOsx= osConvert.replaceString( sceneFileOsx, ourOS, rrScriptHelper.rrOS.Osx,False)
exeOsx= osConvert.replaceString( exeOsx, ourOS, rrScriptHelper.rrOS.Osx,False)
redshiftPathWin=""
redshiftPathLx=""
redshiftPathOsx=""

if (len(exeLx)>0):
    indexBin= exeLx.find("/bin/")
    if (indexBin<=0):
        raise Exception("Linux Executable path does not contain /bin/ in its path '"+exeLx+"'. \nAborting")
    redshiftPathLx=exeLx[:indexBin]

if (len(exeOsx)>0):
    indexBin= exeOsx.find("/bin/")
    if (indexBin<=0):
        raise Exception("OSX Executable path does not contain /bin/ in its path '"+exeOsx+"'. \nAborting")
    redshiftPathOsx=exeOsx[:indexBin]

if (len(exeWin)>0):
    indexBin= exeWin.find("\\bin\\")
    if (indexBin<=0):
        indexBin= exeWin.find("\\bin\\")
        if (indexBin<=0):
            raise Exception("Windows Executable path does not contain \\bin\\ in its path '"+exeWin+"'. \nAborting")
    redshiftPathWin=exeWin[:indexBin]
        

fileBaseName= rrGlobal.rrRootPath()+"inhouse\\rrRedshiftBenchmark"
if (not os.path.isdir(rrGlobal.rrRootPath()+"inhouse")):
    os.mkdir(rrGlobal.rrRootPath()+"inhouse")
    
    

#The commandline will be written as universal OS code and then replaced per OS
batchF = rrGlobal.getCrossBatch()
batchF.osVarAdd("exeFile",exeWin,exeLx,exeOsx)  #Note: debian uses $status and not $?
batchF.osVarAdd("sceneFile",sceneFileWin,sceneFileLx,sceneFileOsx)  #Note: debian uses $status and not $?
batchF.osVarAdd("GPUsInstalledList","%GPUsInstalledList%","${GPUsInstalledList}","${GPUsInstalledList}")  #Note: debian uses $status and not $?
batchF.osVarAdd("rrParseOutput_Exe","rrParseOutput","rrParseOutput","rrParseOutput.app\Contents\MacOS\rrParseOutput") 

batchF.setEnvVar("REDSHIFT_COREDATAPATH",redshiftPathWin,redshiftPathLx,redshiftPathOsx)  #Note: debian uses $status and not $?
batchF.setEnvVar("REDSHIFT_LICENSEPATH",redshiftPathWin,redshiftPathLx,redshiftPathOsx)  #Note: debian uses $status and not $?



batchF.setBaseFileName(fileBaseName)
batchF.addCommentLine("This file was automatically created by a rrSubmitter Scripted Job Plugin ")


#First test with all GPUs if the machine has a gpu
batchF.addCondition("<GPUsInstalledList>","contains","0")

batchF.addFlag("<rrBin><rrParseOutput_Exe>")
batchF.addFlag('\'<exeFile>\' \'<sceneFile>\'')
batchF.addFlag("table")
batchF.addFlag(fileBaseName+"_result.csv")
batchF.addFlag("-showCmdOutput")
batchF.addFlag("-addAllClients")
batchF.addFlag("Workstation,Unique=[host]")
batchF.addFlag("Updated=[dateMonth]")
batchF.addFlag("CPU=CPU:;;")
batchF.addFlag("All GPUs=GPU(s):;;")
batchF.addFlag("Time All GPUs=Time:;;")
batchF.addEnd()
batchF.addEnd()

batchF.addConditionElse()

batchF.addFlag("<rrBin><rrParseOutput_Exe>")
batchF.addFlag('<echo> \'GPU(s):None\'')
batchF.addFlag("table")
batchF.addFlag(fileBaseName+"_result.csv")
batchF.addFlag("-showCmdOutput")
batchF.addFlag("-addAllClients")
batchF.addFlag("Workstation,Unique=[host]")
batchF.addFlag("Updated=[dateMonth]")
batchF.addFlag("CPU=*")
batchF.addFlag("All GPUs=GPU(s):;;")
batchF.addFlag("Time All GPUs=*")
batchF.addEnd()
batchF.addEnd()

batchF.addConditionEndif()


#If there is no second GPU, then we do not need to run the test again
batchF.addCondition("<GPUsInstalledList>","contains","1")

#GPU 0
batchF.addFlag("<rrBin><rrParseOutput_Exe>")
batchF.addFlag('\'<exeFile>\' \'<sceneFile>\' -gpu 0')
batchF.addFlag("table")
batchF.addFlag(fileBaseName+"_result.csv")
batchF.addFlag("-showCmdOutput")
batchF.addFlag("-addAllClients")
batchF.addFlag("Workstation,Unique=[host]")
batchF.addFlag("Updated=[dateMonth]")
batchF.addFlag("CPU=*")
batchF.addFlag("Time GPU0=Time:;;")
batchF.addEnd()
batchF.addEnd()


#GPU 1
batchF.addFlag("<rrBin><rrParseOutput_Exe>")
batchF.addFlag('\'<exeFile>\' \'<sceneFile>\' -gpu 1')
batchF.addFlag("table")
batchF.addFlag(fileBaseName+"_result.csv")
batchF.addFlag("-showCmdOutput")
batchF.addFlag("-addAllClients")
batchF.addFlag("Workstation,Unique=[host]")
batchF.addFlag("Updated=[dateMonth]")
batchF.addFlag("Time GPU1=Time:;;")
batchF.addEnd()
batchF.addEnd()

batchF.addConditionElse()


#GPU 0
batchF.addFlag("<rrBin><rrParseOutput_Exe>")
batchF.addFlag('<echo> \'GPU(s):Same as All GPUs\'')
batchF.addFlag("table")
batchF.addFlag(fileBaseName+"_result.csv")
batchF.addFlag("-showCmdOutput")
batchF.addFlag("-addAllClients")
batchF.addFlag("Workstation,Unique=[host]")
batchF.addFlag("Updated=[dateMonth]")
batchF.addFlag("Time GPU0=Time:;;")
batchF.addEnd()
batchF.addEnd()


#GPU 1
batchF.addFlag("<rrBin><rrParseOutput_Exe>")
batchF.addFlag('<echo> \'GPU(s):None\'')
batchF.addFlag("table")
batchF.addFlag(fileBaseName+"_result.csv")
batchF.addFlag("-showCmdOutput")
batchF.addFlag("-addAllClients")
batchF.addFlag("Workstation,Unique=[host]")
batchF.addFlag("Updated=[dateMonth]")
batchF.addFlag("Time GPU1=Time:;;")
batchF.addEnd()
batchF.addEnd()


batchF.addConditionEndif()

#If there is no third GPU, then the first test would be the same as the next one
batchF.addCondition("<GPUsInstalledList>","contains","2")
#GPU 0+1
batchF.addFlag("<rrBin><rrParseOutput_Exe>")
batchF.addFlag('\'<exeFile>\' \'<sceneFile>\' -gpu 0  -gpu 1')
batchF.addFlag("table")
batchF.addFlag(fileBaseName+"_result.csv")
batchF.addFlag("-showCmdOutput")
batchF.addFlag("-addAllClients")
batchF.addFlag("Workstation,Unique=[host]")
batchF.addFlag("Updated=[dateMonth]")
batchF.addFlag("Time GPU0+1=Time:;;")
batchF.addEnd()
batchF.addEnd()

batchF.addConditionElse()

#GPU 0+1
batchF.addFlag("<rrBin><rrParseOutput_Exe>")
batchF.addFlag('<echo> \'GPU(s):Same as All GPUs\'')
batchF.addFlag("table")
batchF.addFlag(fileBaseName+"_result.csv")
batchF.addFlag("-showCmdOutput")
batchF.addFlag("-addAllClients")
batchF.addFlag("Workstation,Unique=[host]")
batchF.addFlag("Updated=[dateMonth]")
batchF.addFlag("Time GPU0+1=Time:;;")
batchF.addEnd()
batchF.addEnd()


batchF.addConditionEndif()






if not batchF.saveWin():
    raise Exception(batchF.fileErrorMessage())

if not batchF.saveLx():
    raise Exception(batchF.fileErrorMessage())

if not batchF.saveOsx():
    raise Exception(batchF.fileErrorMessage())





#Create the job
renderApp= rrJob._RenderAppBasic()
renderApp.clear()
renderApp.name="Execute"
renderApp.type="Execute"
renderApp.executeType=rrGlobal.executeJobType.onceEachClient
renderApp.rendererName="Redshift Benchmark"


newJob=  rr.getNewJob()
newJob.overrideIcon=overrideIcon;
newJob.sceneName=batchF.getOSFileName(0);
newJob.renderApp=renderApp
newJob.companyProjectName="rrCommand"
newJob.imageFileName=fileBaseName+"_result.csv"
newJob.imageSingleOutputFile=True
newJob.splitImageFileInto_DirFileExt(False)
newJob.uiIsChecked= True
newJob.layer="Redshift Benchmark"

rr.setSubmitterParameter("MaxClientsAtATime=0~10")




rr.jobAll_set(999,newJob);  # If the index of the job is higher than the number of jobs,
                            # then a new job is added to the end of the job list. So I use 999.
